#include "atlas_taffinity.h"
#include "atlas_misc.h"
#include "assert.h"

void PrintUsage(char *nam)
{
   fprintf(stderr, "\nUSAGE: %s [-o <outfile>]\n", nam);
   exit(-1);
}

void GetFlags(int nargs, char **args, FILE **fpout)
{
   int i;

   *fpout=stdout;
   for (i=1; i < nargs; i++)
   {
      if (args[i][0] != '-') PrintUsage(args[0]);
      switch(args[i][1])
      {
      case 'o':
         *fpout = fopen(args[++i], "w");
         assert(*fpout);
         break;
      default:
         PrintUsage(args[0]);
      }
   }
}

void getLaunchOrder(int P, int *lo)
{
   int i, j, k, stop, dest;

   for (i=0; (1<<i) < P; i++)
   lo[0] = 0;
   k = 1;
   for (i--; i >= 0; i--)
   {
      stop = k;
      for (j=0; j < stop; j++)
      {
         dest = lo[j] + (1<<i);
         if (dest < P)
            lo[k++] = dest;
         if (k == P)
            return;
      }
   }
}

int main(int nargs, char **args)
{
   FILE *fpout;
   int i, j, k, P;
   int *lo;
   GetFlags(nargs, args, &fpout);

   fprintf(fpout, "  /* This file generated by %s */\n", __FILE__);
   fprintf(fpout, "#ifndef ATLAS_NTHREADS_H\n   #define ATLAS_NTHREADS_H\n\n");
   fprintf(fpout,
      "   #ifndef ATL_WINTHREADS\n      #include \"pthread.h\"\n   #endif\n");
   #if ATL_NCPU != 0
      P = ATL_NCPU;
   #elif defined(ATL_AFF_NUMID)
      P = ATL_AFF_NUMID;
   #else
      P = 4;
   #endif
   #if defined(ATL_AFF_NUMID)
      #if ATL_NCPU > ATL_AFF_NUMID
         fprintf(fpout,
         "/*\n * I should have tested if NTHREADS = %d(NCPU) or %d(NAFFIDs)\n");
         fprintf(fpout, " * is better.  For now, assuming %d\n */", ATL_NCPU);
      #endif
   #endif
   fprintf(fpout, "   #define ATL_NTHREADS %d\n", P);
   for (i=0; (1<<i) < P; i++);
   fprintf(fpout, "   #define ATL_NTHRPOW2 %d\n", i);
   lo = malloc(P*sizeof(int));
   getLaunchOrder(P, lo);
   fprintf(fpout, "   #ifdef ATL_LAUNCHORDER\n");
   fprintf(fpout, "       static int ATL_launchorder[%d] = {0", P);
   for (i=1; i < P; i++)
      fprintf(fpout, ",%d", lo[i]);
   fprintf(fpout, "};\n   #endif\n");
   #if defined(ATL_AFF_NUMID) && !defined(ATL_RANK_IS_PROCESSORID)
      fprintf(fpout, "   #if defined(ATL_RANK2ID)\n");
      fprintf(fpout, "       static int ATL_rank2ID[%d] = {%d",
              P, ATL_affinityIDs[0]);
      for (i=1; i < P; i++)
         fprintf(fpout, ",%d", ATL_affinityIDs[i%ATL_AFF_NUMID]);
      fprintf(fpout, "};\n   #endif\n");
   #endif
   fprintf(fpout, "\n#endif\n");
   fclose(fpout);
   return(0);
}
